<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouponSettingByParams(array $params)
 * @method getSkuEffectiveCouponsByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取零售优惠券设置信息
     *
     * @param  int $id 配置id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponSetting (int $id) {
        return self::getClass()->getCouponSetting([
            "id" => $id,
        ]);
    }

    /**
     * 检测商品信息和优惠券信息计算优惠信息
     *
     * @support  int $userId 用户id [ require true ]
     * @support  array $products 订单故障信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuEffectiveCoupons () {
        return self::getClass()->getSkuEffectiveCoupons();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}