<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setOrderNameByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method closeByUserByParams(array $params)
 * @method closeByLimitTimeNotPaidByParams(array $params)
 */
class OrderV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自动创建下一天的零售商城初始单号(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderName () {
        return self::getClass()->setOrderName();
    }

    /**
     * 创建订单
     *
     * @support  int $userId 下单用户ID [ require true ]
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户性别 
     * @support  string $userBirthday 用户生日 
     * @support  float $money 订单金额(商品原价总额) [Original type double] [ require true ]
     * @support  float $originalMoney 订单的原价总额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额(商品优惠之后的总额) [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  int $inputStaffId 售出伙伴ID 
     * @support  string $note 备注 
     * @support  string $from 订单来源（pc:管理端、mobile:预约端, mall:微信商城小程序） [ require true ]
     * @support  string $source 销售来源（onlineSales:线上、offlineSales 线下、memberSales会员权益、gift赠品、customPlatform定制商城） 
     * @support  array $couponIds 优惠券/产品券ids 
     * @support  array $expressInfo 物流信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 订单详情
     *
     * @support  int $id 订单ID 
     * @support  string $orderNo 订单号 
     * @support  int $himoOrderId 海马体订单id 
     * @support  string $source 销售来源（onlineSales:线上、offlineSales 线下、memberSales会员权益、gift赠品、customPlatform定制商城） 
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 订单列表
     *
     * @support  int $himoOrderId 海马体订单id 
     * @support  array $himoOrderIds 海马体订单ids 
     * @support  string $userPhone 电话号码 
     * @support  string $createTimeStart 创建开始时间 
     * @support  string $createTimeEnd 创建结束时间 
     * @support  string $paidTimeStart 支付起始时间 
     * @support  string $paidTimeEnd 支付结束时间 
     * @support  string $userName 用户姓名 
     * @support  string $orderNo 订单号 
     * @support  int $storeId 门店ID 
     * @support  string $status 状态 
     * @support  int $inputStaffId 售出伙伴ID 
     * @support  int $invoiceId 发票id 
     * @support  array $statusList 状态列表 
     * @support  string $payType 支付方式 
     * @support  string $source 订单业务来源 
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @support  string $expressStatus 订单状态 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 用户手动关闭订单——未支付状态
     *
     * @support  int $userId 下单用户ID [ require true ]
     * @support  int $id 订单id [ require true ]
     * @support  string $reason 关单原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeByUser () {
        return self::getClass()->closeByUser();
    }

    /**
     * 关闭已提交但是未支付的订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeByLimitTimeNotPaid () {
        return self::getClass()->closeByLimitTimeNotPaid();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'OrderV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'OrderV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}