<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setProductOrderNameByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method callBackProductStatusChangeByParams(array $params)
 * @method listByParams(array $params)
 */
class ProductOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 自动创建下一天的零售商城生产订单初始单号(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProductOrderName () {
        return self::getClass()->setProductOrderName();
    }

    /**
     * 创建生产单
     *
     * @support  int $orderId 商城订单id [ require true ]
     * @support  int $orderItemId 商城订单明细id [ require true ]
     * @support  int $num 生产数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 生产订单详情
     *
     * @param  int $productOrderId 生产订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $productOrderId) {
        return self::getClass()->detail([
            "productOrderId" => $productOrderId,
        ]);
    }

    /**
     * 生产订单状态变动回调
     *
     * @param  array $data 生产订单状态变动回调数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callBackProductStatusChange (array $data) {
        return self::getClass()->callBackProductStatusChange([
            "data" => $data,
        ]);
    }

    /**
     * 生产订单列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'ProductOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'ProductOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}