<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hangUpByParams(array $params)
 * @method takeBackByParams(array $params)
 * @method getTakeBacksByParams(array $params)
 * @method deleteHangUpByParams(array $params)
 * @method cleanHangUpByParams(array $params)
 */
class PendingOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 挂单
     *
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @param  array $info 待下单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hangUp (int $storeId, array $info) {
        return self::getClass()->hangUp([
            "storeId" => $storeId,
            "info" => $info,
        ]);
    }

    /**
     * 取单
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @support  int $storeId 门店id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeBack (int $id) {
        return self::getClass()->takeBack([
            "id" => $id,
        ]);
    }

    /**
     * 获取挂单s
     *
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTakeBacks (int $storeId) {
        return self::getClass()->getTakeBacks([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 删除挂单
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @support  int $storeId 门店id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteHangUp (int $id) {
        return self::getClass()->deleteHangUp([
            "id" => $id,
        ]);
    }

    /**
     * 清空挂单(定时)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cleanHangUp () {
        return self::getClass()->cleanHangUp();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'PendingOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'PendingOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}