<?php
namespace Mainto\Bridge\Enums\RetailOrder;

class OrderStatusV2Enum {
    const NO_SUBMIT = 'no_submit';
    const SUBMITTED = 'submitted';
    const CONFIRMING = 'confirming';
    const PAID = 'paid';
    const PEND_PRODUCE = 'pend_produce';
    const PART_PRODUCE = 'part_produce';
    const PRODUCED = 'produced';
    const PART_SHIP = 'part_ship';
    const SHIPPED = 'shipped';
    const PART_RECEIVED = 'part_received';
    const RECEIVED = 'received';
    const TRANSPORTING = 'transporting';
    const FINISHED = 'finished';
    const CLOSED = 'closed';
    const AFTER_SALE_CLOSED = 'after_sale_closed';
    const FINANCE_CLOSED = 'finance_closed';
    const CANCELED = 'canceled';
    const ALL_ORDER_STATUS = [0 => 'no_submit',1 => 'submitted',2 => 'confirming',3 => 'paid',4 => 'transporting',5 => 'finished',6 => 'closed',7 => 'after_sale_closed',8 => 'finance_closed',9 => 'canceled'];
    const CHANGE_ORDER_STATUS = ['paid' => [0 => 'paid'],'finished' => [0 => 'finished'],'submitted' => [0 => 'no_submit',1 => 'submitted']];
}