<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method checkCanRefundMaxMoneyByParams(array $params)
 * @method checkReturnGoodsNumByParams(array $params)
 * @method checkAfterSaleNumByParams(array $params)
 * @method getByOrderIdByParams(array $params)
 * @method getDetailByIdByParams(array $params)
 * @method closeByParams(array $params)
 * @method resubmitByParams(array $params)
 * @method getReturnGoodsByOrderIdByParams(array $params)
 * @method getReturnGoodsItemsByOrderIdByParams(array $params)
 * @method getReturnGoodsItemsByAfterSaleIdsByParams(array $params)
 * @method getReturnGoodsAndItemsByOrderIdByParams(array $params)
 * @method getRefundByOrderIdByParams(array $params)
 * @method handleAfterSaleRefundByParams(array $params)
 */
class AfterSale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建售后单
     *
     * @support  int $himoOrderId 海马体订单id 
     * @support  int $orderId 零售订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 售后单类型 [ require true ]
     * @support  array $refundItemDetail 退款产品明细 
     * @support  string $reason 退款原因 [ require true ]
     * @support  string $note 退换货说明 
     * @support  int $confirmReturnInvoice 确认须退发票 
     * @support  float $money 退款金额 [Original type double] 
     * @support  string $people 退款人 
     * @support  string $account 退款账户 
     * @support  int $isStaffPay 是否为伙伴垫付 
     * @support  array $staffPayCertificate 对公打款支付凭证图片地址 
     * @support  string $from 退款来源:user 用户端， manager 后台 [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @support  int $operateId 操作伙伴ID(后台操作时必须添加) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 检查最大可以退款金额是否符合要求
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @param  float $money 要退款的金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkCanRefundMaxMoney (int $orderId, float $money) {
        return self::getClass()->checkCanRefundMaxMoney([
            "orderId" => $orderId,
            "money" => $money,
        ]);
    }

    /**
     * 后续请使用 checkAfterSaleNum 方法
     * @deprecated
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @param  array $refundItemDetail 退款产品明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkReturnGoodsNum (int $orderId, array $refundItemDetail) {
        return self::getClass()->checkReturnGoodsNum([
            "orderId" => $orderId,
            "refundItemDetail" => $refundItemDetail,
        ]);
    }

    /**
     * 检查售后数量是否符合要求
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @param  array $refundItemDetail 退款产品明细 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkAfterSaleNum (int $orderId, array $refundItemDetail) {
        return self::getClass()->checkAfterSaleNum([
            "orderId" => $orderId,
            "refundItemDetail" => $refundItemDetail,
        ]);
    }

    /**
     * 根据零售订单id查询售后单
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getByOrderId (int $orderId) {
        return self::getClass()->getByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据售后单id查询售后单详情
     *
     * @param  int $id 售后单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailById (int $id) {
        return self::getClass()->getDetailById([
            "id" => $id,
        ]);
    }

    /**
     * 根据售后单id关闭售后单
     *
     * @param  int $id 售后单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * 重新提交售后单
     *
     * @support  int $id 售后单id [ require true ]
     * @support  string $people 退款人 
     * @support  string $account 退款账户 
     * @support  int $isStaffPay 是否为伙伴垫付 
     * @support  array $staffPayCertificate 对公打款支付凭证图片地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function resubmit () {
        return self::getClass()->resubmit();
    }

    /**
     * 根据零售订单id查询退货信息
     *
     * @param  int $orderId 售后单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReturnGoodsByOrderId (int $orderId) {
        return self::getClass()->getReturnGoodsByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据零售订单id查询退货详细items
     *
     * @param  int $orderId 售后单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReturnGoodsItemsByOrderId (int $orderId) {
        return self::getClass()->getReturnGoodsItemsByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据零售售后单id查询退货详细items
     *
     * @param  array $afterSaleIds 售后单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReturnGoodsItemsByAfterSaleIds (array $afterSaleIds) {
        return self::getClass()->getReturnGoodsItemsByAfterSaleIds([
            "afterSaleIds" => $afterSaleIds,
        ]);
    }

    /**
     * 根据零售订单id查询退货信息和退货itmes信息
     *
     * @param  int $orderId 售后单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReturnGoodsAndItemsByOrderId (int $orderId) {
        return self::getClass()->getReturnGoodsAndItemsByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据零售订单id查询退款信息
     *
     * @param  int $orderId 售后单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRefundByOrderId (int $orderId) {
        return self::getClass()->getRefundByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据售后单id，处理下层的退款单
     *
     * @param  int $id 售后单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleAfterSaleRefund (int $id) {
        return self::getClass()->handleAfterSaleRefund([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'AfterSale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'AfterSale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}