<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getByCodeByParams(array $params)
 * @method getByOrderNoByParams(array $params)
 * @method getVerifyWithDeleteStatusByOrderNoByParams(array $params)
 * @method removeByParams(array $params)
 * @method removeVerifyCodeByParams(array $params)
 */
class Verify {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成提货码信息
     *
     * @param  int $storeId 提货门店id [ require true ]
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (int $storeId, string $orderNo) {
        return self::getClass()->create([
            "storeId" => $storeId,
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 通过提货码查询核销信息
     *
     * @param  string $code 提货码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getByCode (string $code) {
        return self::getClass()->getByCode([
            "code" => $code,
        ]);
    }

    /**
     * 通过订单号查询核销信息
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getByOrderNo (string $orderNo) {
        return self::getClass()->getByOrderNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 通过订单号查询核销信息，可以查询已经删除的信息
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVerifyWithDeleteStatusByOrderNo (string $orderNo) {
        return self::getClass()->getVerifyWithDeleteStatusByOrderNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 确认核销，删除提货码
     *
     * @param  int $code 提货码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $code) {
        return self::getClass()->remove([
            "code" => $code,
        ]);
    }

    /**
     * 自动软删除已经失效的自提核销提货码(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeVerifyCode () {
        return self::getClass()->removeVerifyCode();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Verify');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Verify');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}