<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getByOrderIdByParams(array $params)
 * @method getDetailByIdByParams(array $params)
 * @method closeByParams(array $params)
 * @method getOrderCanRefundInfoByParams(array $params)
 */
class AfterSale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建售后单
     *
     * @support  int $himoOrderId 海马体订单id 
     * @support  int $orderId 零售订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $type 售后单类型 [ require true ]
     * @support  array $refundItemDetail 退款产品明细 
     * @support  string $reason 退款原因 [ require true ]
     * @support  string $note 退换货说明 
     * @support  float $money 退款金额 [Original type double] 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  int $isStaffPay 是否为伙伴垫付 
     * @support  array $staffPayCertificate 对公打款支付凭证图片地址 
     * @support  string $from 退款来源:user 用户端， manager 后台 [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @support  int $operateId 操作伙伴ID(后台操作时必须添加) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑售后单，重新提交
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 根据零售订单id查询售后单
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getByOrderId (int $orderId) {
        return self::getClass()->getByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据售后单id查询售后单详情
     *
     * @param  int $id 售后单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailById (int $id) {
        return self::getClass()->getDetailById([
            "id" => $id,
        ]);
    }

    /**
     * 根据售后单id关闭售后单
     *
     * @param  int $id 售后单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * getOrderCanRefundInfo
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderCanRefundInfo () {
        return self::getClass()->getOrderCanRefundInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'AfterSale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'AfterSale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}