<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getByCodeByParams(array $params)
 * @method removeByParams(array $params)
 */
class Verify {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成提货码信息
     *
     * @param  int $store_id 提货门店id [ require true ]
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (int $store_id, string $order_no) {
        return self::getClass()->create([
            "store_id" => $store_id,
            "order_no" => $order_no,
        ]);
    }

    /**
     * 查询核销信息
     *
     * @param  int $code 提货码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getByCode (int $code) {
        return self::getClass()->getByCode([
            "code" => $code,
        ]);
    }

    /**
     * 确认核销，删除提货码
     *
     * @param  int $code 提货码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $code) {
        return self::getClass()->remove([
            "code" => $code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Verify');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Verify');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}