<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method promotionOrderByParams(array $params)
 */
class PromotionOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取促销订单的信息
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  array $orderInfo 购买商品详情 [ require true ]
     * @param  bool $isStaff 是否是内部员工 [ require true ]
     * @param  bool $useStaffDiscount 是否使用员工优惠 [ require true ]
     * @param  string $managerDiscountType managerDiscountType [ require true ]
     * @param  float $managerDiscountAmount managerDiscountAmount [Original type double] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function promotionOrder (int $storeId, array $orderInfo, bool $isStaff = false, bool $useStaffDiscount = false, string $managerDiscountType = '', float $managerDiscountAmount = 0.0) {
        return self::getClass()->promotionOrder([
            "storeId" => $storeId,
            "orderInfo" => $orderInfo,
            "isStaff" => $isStaff,
            "useStaffDiscount" => $useStaffDiscount,
            "managerDiscountType" => $managerDiscountType,
            "managerDiscountAmount" => $managerDiscountAmount,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'PromotionOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'PromotionOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}