<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getListByParams(array $params)
 */
class ActivityRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建活动参与记录
     *
     * @param  string $type 类型 [ require true ]
     * @param  int $orderId 拍摄订单id [Original type uint] [ require true ]
     * @param  float $orderMoney 订单金额 [Original type double] [ require true ]
     * @param  array $orderProducts 订单产品 [ require true ]
     * @param  float $discount 优惠信息 [Original type double] [ require true ]
     * @param  int $createBy 创建人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $type, int $orderId, float $orderMoney, array $orderProducts, float $discount, int $createBy) {
        return self::getClass()->create([
            "type" => $type,
            "orderId" => $orderId,
            "orderMoney" => $orderMoney,
            "orderProducts" => $orderProducts,
            "discount" => $discount,
            "createBy" => $createBy,
        ]);
    }

    /**
     * 查询活动参与记录
     *
     * @param  int $orderId 拍摄订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $orderId) {
        return self::getClass()->getList([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'ActivityRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'ActivityRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}