<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method submitByParams(array $params)
 * @method removeByParams(array $params)
 * @method deletePaidByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method listByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method closeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method getProductsInOrdersByParams(array $params)
 * @method modifyOrderInputStaffIdByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 * @method listInOrdersByParams(array $params)
 * @method getOrderAmountsPayableByParams(array $params)
 * @method getStaffRetailEffectByParams(array $params)
 * @method closeByHimoOrderIdByParams(array $params)
 * @method orderItemsFinishExpressByParams(array $params)
 * @method orderItemsCancelExpressByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $himoOrderId 海马体订单id 
     * @support  int $userId 下单用户ID 
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户性别 
     * @support  string $userBirthday 用户生日 
     * @support  float $money 订单金额(商品原价总额) [Original type double] [ require true ]
     * @support  float $originalMoney 订单的原价总额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额(商品优惠之后的总额) [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  string $note 备注 
     * @support  int $inputStaffId 售出伙伴ID 
     * @support  string $from 订单来源（pc:管理端、mobile 预约端） [ require true ]
     * @support  string $status 订单状态 
     * @param  int $operateId 录入伙伴ID(后台操作时必须添加) [ require true ]
     * @support  bool $isStaff 是否是内部员工 
     * @support  bool $useStaffDiscount 是否使用员工优惠 
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $operateId = 0) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 编辑订单
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $id 订单ID [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户性别 
     * @support  string $userBirthday 用户生日 
     * @support  int $inputStaffId 售出伙伴ID 
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额(商品优惠之后的总额) [Original type double] [ require true ]
     * @support  float $originalMoney 订单的原价总额 [Original type double] [ require true ]
     * @support  array $detail 订单详情(零售商品信息) [ require true ]
     * @support  string $note 备注 
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @support  string $from 订单来源（pc:管理端、mobile 预约端） [ require true ]
     * @support  bool $isStaff 是否是内部员工 
     * @support  bool $useStaffDiscount 是否使用员工优惠 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id = 0, int $operateId = 0, string $orderNo = '') {
        return self::getClass()->update([
            "id" => $id,
            "operateId" => $operateId,
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 订单详情
     *
     * @support  int $id 订单ID 
     * @support  string $orderNo 订单号 [ require true ]
     * @support  int $himoOrderId 海马体订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 提交订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId = 0) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 删除订单(已支付)——不建议使用
     * @deprecated
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePaid (int $id, int $operateId = 0) {
        return self::getClass()->deletePaid([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改订单支付方式
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changePayType (int $id, string $payType, string $paymentNo = '', int $operateId = 0) {
        return self::getClass()->changePayType([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 订单列表
     *
     * @support  int $himoOrderId 海马体订单id 
     * @support  string $userPhone 电话号码 
     * @support  string $createTimeStart 创建开始时间 
     * @support  string $createTimeEnd 创建结束时间 
     * @support  string $paidTimeStart 支付起始时间 
     * @support  string $paidTimeEnd 支付结束时间 
     * @support  string $userName 用户姓名 
     * @support  string $orderNo 订单号 
     * @support  int $storeId 门店ID 
     * @support  string $status 状态 
     * @support  int $inputStaffId 售出伙伴ID 
     * @support  int $invoiceId 发票id 
     * @support  array $statusList 状态列表 
     * @support  string $payType 支付方式 
     * @support  int $page 页数 
     * @support  int $pageSize 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 设置订单完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  float $money 订单金额 [Original type double] [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  int $inputStaffId 售出伙伴ID [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @support  string $status 订单状态 
     * @param  string $certificate 支付凭证 [ require true ]
     * @param  string $paymentTime 对公打款时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, float $money, string $payType, int $inputStaffId = 0, string $paymentNo = '', string $certificate = '', string $paymentTime = '', int $operateId = 0) {
        return self::getClass()->setPaid([
            "id" => $id,
            "money" => $money,
            "payType" => $payType,
            "inputStaffId" => $inputStaffId,
            "paymentNo" => $paymentNo,
            "certificate" => $certificate,
            "paymentTime" => $paymentTime,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason, int $operateId = 0) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $userName 用户姓名 [ require true ]
     * @param  string $userPhone 用户手机号 [ require true ]
     * @param  string $userSex 用户性别 [ require true ]
     * @param  string $userBirthday 用户生日 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData (int $id, int $operateId = 0, string $userName = '', string $userPhone = '', string $userSex = '', string $userBirthday = '') {
        return self::getClass()->changeUserData([
            "id" => $id,
            "operateId" => $operateId,
            "userName" => $userName,
            "userPhone" => $userPhone,
            "userSex" => $userSex,
            "userBirthday" => $userBirthday,
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $orderNo) {
        return self::getClass()->getIdByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单信息获取订单下面买的产品
     *
     * @support  string $orderNo 订单号 
     * @support  int $id 订单ID 
     * @support  int $himoOrderId 海马体订单ID 
     * @support  int $userId 用户id 
     * @support  int $storeId 店铺id 
     * @support  string $status 订单状态 
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrder () {
        return self::getClass()->getProductsInOrder();
    }

    /**
     * 根据订单信息批量获取订单下面买的产品
     *
     * @support  array $orderNos 订单号数组 [ require true ]
     * @support  array $ids 订单ID数组 
     * @support  array $himoOrderIds 海马体订单ID数组 
     * @support  array $userIds 用户id数组 
     * @support  int $storeId 店铺id 
     * @support  string $status 订单状态 
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrders () {
        return self::getClass()->getProductsInOrders();
    }

    /**
     * 修改零售订单关联销售人员
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $inputStaffId 售出伙伴ID [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyOrderInputStaffId (int $id, int $inputStaffId = 0, int $operateId = 0) {
        return self::getClass()->modifyOrderInputStaffId([
            "id" => $id,
            "inputStaffId" => $inputStaffId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 设置服务完成
     *
     * @param  int $id id [ require true ]
     * @param  bool $isUserComplete 是否是用户确认 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceComplete (int $id, bool $isUserComplete = true) {
        return self::getClass()->serviceComplete([
            "id" => $id,
            "isUserComplete" => $isUserComplete,
        ]);
    }

    /**
     * 批量更新订单的发票ID
     *
     * @param  int $invoiceId 发票ID [ require true ]
     * @param  array $orderNos 订单号数组 [ require true ]
     * @param  int $operateId 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (int $invoiceId, array $orderNos, int $operateId) {
        return self::getClass()->batchUpdateInvoiceId([
            "invoiceId" => $invoiceId,
            "orderNos" => $orderNos,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 根据订单号批量获取订单信息
     *
     * @support  array $himoOrderIds 海马体订单ID数组 
     * @support  array $orderNos 订单号数组 [ require true ]
     * @support  array $ids 订单ID数组 
     * @support  array $userIds 用户id数组 
     * @support  string $status 订单状态 
     * @throws  \Exception
     * @return  array
     */
    public static function listInOrders () {
        return self::getClass()->listInOrders();
    }

    /**
     * 获取订单应付金额
     *
     * @param  int $id 订单id [ require true ]
     * @param  int $himoOrderId 海马体订单id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getOrderAmountsPayable (int $id = 0, int $himoOrderId = 0) {
        return self::getClass()->getOrderAmountsPayable([
            "id" => $id,
            "himoOrderId" => $himoOrderId,
        ]);
    }

    /**
     * 获取伙伴时间范围内累积零售产品销售
     *
     * @param  int $staffId 伙伴工号 [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffRetailEffect (int $staffId, string $startTime, string $endTime) {
        return self::getClass()->getStaffRetailEffect([
            "staffId" => $staffId,
            "startTime" => $startTime,
            "endTime" => $endTime,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $himoOrderId 海马体订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeByHimoOrderId (int $himoOrderId, string $reason) {
        return self::getClass()->closeByHimoOrderId([
            "himoOrderId" => $himoOrderId,
            "reason" => $reason,
        ]);
    }

    /**
     * 设置订单商品完成自提
     *
     * @param  int $itemId 订单ItemId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderItemsFinishExpress (int $itemId) {
        return self::getClass()->orderItemsFinishExpress([
            "itemId" => $itemId,
        ]);
    }

    /**
     * 取消订单商品完成自提状态
     *
     * @param  int $itemId 订单ItemId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderItemsCancelExpress (int $itemId) {
        return self::getClass()->orderItemsCancelExpress([
            "itemId" => $itemId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}