<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByOrderNoByParams(array $params)
 * @method detailByHimoOrderIdByParams(array $params)
 * @method submitByParams(array $params)
 * @method removeByParams(array $params)
 * @method deletePaidByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method listByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method closeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method getItemsInOrderByParams(array $params)
 * @method getItemsInOrdersByParams(array $params)
 * @method modifyOrderInputStaffIdByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 * @method listInOrdersByParams(array $params)
 * @method getOrderAmountsPayableByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $user_name 用户名 
     * @support  string $user_phone 用户手机号 
     * @support  string $user_sex 用户性别 
     * @support  string $user_birthday 用户生日 
     * @support  float $money 订单金额(商品原价总额) [Original type double] [ require true ]
     * @support  float $real_money 订单实付金额(商品优惠之后的总额) [Original type double] [ require true ]
     * @support  int $order_user_id 下单用户ID（仅用于管理端帮客户开单） 
     * @support  int $himo_order_id 海马体订单id 
     * @support  int $input_staff_id 售出伙伴ID 
     * @support  array $global_discount_ids 全局优惠ID 
     * @support  float $global_discount_money 全局优惠金额 [Original type double] 
     * @support  int $coupon_id 优惠券ID 
     * @support  float $coupon_deduction_money 优惠券抵扣金额 [Original type double] 
     * @support  int $product_card_id 产品卡ID 
     * @support  float $gift_card_pay_money 礼品卡金额 [Original type double] 
     * @support  float $product_card_deduction_money 产品卡抵扣金额 [Original type double] 
     * @support  float $special_discount_money 特殊折扣金额 [Original type double] 
     * @support  string $special_discount_note 特殊折扣备注 
     * @support  int $operate_id 录入伙伴ID(后台操作时必须添加) 
     * @support  array $detail 订单详情 [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑订单
     *
     * @support  string $order_no 订单号 
     * @support  int $id 订单ID 
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $user_name 用户名 
     * @support  string $user_phone 用户手机号 
     * @support  string $user_sex 用户性别 
     * @support  string $user_birthday 用户生日 
     * @support  int $input_staff_id 售出伙伴ID 
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  array $global_discount_ids 全局优惠ID 
     * @support  float $global_discount_money 全局优惠金额 [Original type double] 
     * @support  int $coupon_id 优惠券ID 
     * @support  float $coupon_deduction_money 优惠券抵扣金额 [Original type double] 
     * @support  int $product_card_id 产品卡ID 
     * @support  float $gift_card_pay_money 礼品卡金额 [Original type double] 
     * @support  float $product_card_deduction_money 产品卡抵扣金额 [Original type double] 
     * @support  float $special_discount_money 特殊折扣金额 [Original type double] 
     * @support  string $special_discount_note 特殊折扣备注 
     * @support  array $detail 订单详情(零售商品信息) [ require true ]
     * @support  string $note 备注 
     * @support  int $operate_id 操作伙伴ID(后台操作时必须添加) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单详情【根据订单号获取】
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByOrderNo (string $order_no) {
        return self::getClass()->detailByOrderNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 订单详情【根据海马体订单id】
     *
     * @param  int $himo_order_id 海马体订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByHimoOrderId (int $himo_order_id) {
        return self::getClass()->detailByHimoOrderId([
            "himo_order_id" => $himo_order_id,
        ]);
    }

    /**
     * 提交订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 删除订单(可以移除)
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operate_id 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operate_id = 0) {
        return self::getClass()->remove([
            "id" => $id,
            "operate_id" => $operate_id,
        ]);
    }

    /**
     * 删除订单（已支付）——该功能移除
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operate_id 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePaid (int $id, int $operate_id = 0) {
        return self::getClass()->deletePaid([
            "id" => $id,
            "operate_id" => $operate_id,
        ]);
    }

    /**
     * 修改订单支付方式
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @param  int $operate_id 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changePayType (int $id, string $pay_type, int $operate_id, string $payment_no = '') {
        return self::getClass()->changePayType([
            "id" => $id,
            "pay_type" => $pay_type,
            "operate_id" => $operate_id,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 订单列表
     *
     * @support  int $himo_order_id 海马体订单id 
     * @support  string $user_phone 电话号码 
     * @support  string $create_time_start 创建开始时间 
     * @support  string $create_time_end 创建结束时间 
     * @support  string $paid_time_start 支付起始时间 
     * @support  string $paid_time_end 支付结束时间 
     * @support  string $user_name 用户姓名 
     * @support  string $order_no 订单号 
     * @support  int $store_id 门店ID 
     * @support  string $status 状态 
     * @support  int $input_staff_id 售出伙伴ID 
     * @support  int $invoice_id 发票id 
     * @support  array $status_list 状态列表 
     * @support  string $pay_type 支付方式 
     * @support  int $page 页数 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 设置订单完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  float $money 订单金额 [Original type double] [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  int $input_staff_id 售出伙伴ID [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @param  int $operate_id 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, float $money, string $pay_type, int $input_staff_id = 0, string $payment_no = '', int $operate_id = 0) {
        return self::getClass()->setPaid([
            "id" => $id,
            "money" => $money,
            "pay_type" => $pay_type,
            "input_staff_id" => $input_staff_id,
            "payment_no" => $payment_no,
            "operate_id" => $operate_id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operate_id 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason, int $operate_id = 0) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
            "operate_id" => $operate_id,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $user_name 用户姓名 [ require true ]
     * @param  string $user_phone 用户手机号 [ require true ]
     * @param  string $user_sex 用户性别 [ require true ]
     * @param  string $user_birthday 用户生日 [ require true ]
     * @param  int $operate_id 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData (int $id, string $user_name, string $user_phone, string $user_sex = '', string $user_birthday = '', int $operate_id = 0) {
        return self::getClass()->changeUserData([
            "id" => $id,
            "user_name" => $user_name,
            "user_phone" => $user_phone,
            "user_sex" => $user_sex,
            "user_birthday" => $user_birthday,
            "operate_id" => $operate_id,
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $order_no) {
        return self::getClass()->getIdByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单信息获取订单下面买的产品
     *
     * @param  string $order_no 订单号 [ require true ]
     * @param  int $id 订单ID [ require true ]
     * @param  int $himo_order_id 海马体订单ID [ require true ]
     * @param  int $order_user_id 用户id [ require true ]
     * @param  int $store_id 店铺id [ require true ]
     * @param  string $status 订单状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsInOrder (string $status, string $order_no = NULL, int $id = NULL, int $himo_order_id = NULL, int $order_user_id = NULL, int $store_id = NULL) {
        return self::getClass()->getItemsInOrder([
            "status" => $status,
            "order_no" => $order_no,
            "id" => $id,
            "himo_order_id" => $himo_order_id,
            "order_user_id" => $order_user_id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 根据订单信息批量获取订单下面买的产品
     *
     * @param  array $order_nos 订单号数组 [ require true ]
     * @param  array $ids 订单ID数组 [ require true ]
     * @param  array $himo_order_ids 海马体订单ID数组 [ require true ]
     * @param  array $order_user_ids 用户id数组 [ require true ]
     * @param  int $store_id 店铺id [ require true ]
     * @param  string $status 订单状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsInOrders (string $status, array $order_nos = [], array $ids = [], array $himo_order_ids = [], array $order_user_ids = [], int $store_id = NULL) {
        return self::getClass()->getItemsInOrders([
            "status" => $status,
            "order_nos" => $order_nos,
            "ids" => $ids,
            "himo_order_ids" => $himo_order_ids,
            "order_user_ids" => $order_user_ids,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 零售订单关联销售人员
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $input_staff_id 售出伙伴ID [ require true ]
     * @param  int $operate_id 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyOrderInputStaffId (int $id, int $input_staff_id, int $operate_id) {
        return self::getClass()->modifyOrderInputStaffId([
            "id" => $id,
            "input_staff_id" => $input_staff_id,
            "operate_id" => $operate_id,
        ]);
    }

    /**
     * 服务完成
     *
     * @param  int $id id [ require true ]
     * @param  bool $is_user_complete 是否是用户确认 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceComplete (int $id, bool $is_user_complete = true) {
        return self::getClass()->serviceComplete([
            "id" => $id,
            "is_user_complete" => $is_user_complete,
        ]);
    }

    /**
     * 批量更新订单的发票ID
     *
     * @param  int $invoice_id 发票ID [ require true ]
     * @param  array $order_nos 订单号数组 [ require true ]
     * @param  int $operate_id 操作伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (int $invoice_id, array $order_nos, int $operate_id) {
        return self::getClass()->batchUpdateInvoiceId([
            "invoice_id" => $invoice_id,
            "order_nos" => $order_nos,
            "operate_id" => $operate_id,
        ]);
    }

    /**
     * 批量获取订单列表
     *
     * @param  array $himo_order_ids 海马体订单ID数组 [ require true ]
     * @param  array $order_nos 订单号数组 [ require true ]
     * @param  array $ids 订单ID数组 [ require true ]
     * @param  array $order_user_ids 用户id数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listInOrders (array $order_nos = [], array $ids = [], array $himo_order_ids = [], array $order_user_ids = []) {
        return self::getClass()->listInOrders([
            "order_nos" => $order_nos,
            "ids" => $ids,
            "himo_order_ids" => $himo_order_ids,
            "order_user_ids" => $order_user_ids,
        ]);
    }

    /**
     * 获取订单应付金额
     *
     * @param  int $id 订单id [ require true ]
     * @param  int $himo_order_id 海马体订单id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getOrderAmountsPayable (int $id = 0, int $himo_order_id = 0) {
        return self::getClass()->getOrderAmountsPayable([
            "id" => $id,
            "himo_order_id" => $himo_order_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}