<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method treeByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method removeByParams(array $params)
 */
class RefundReason {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款原因选项列表
     *
     * @param  int $parent  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $parent = 0) {
        return self::getClass()->list([
            "parent" => $parent,
        ]);
    }

    /**
     * 退款原因选项列表树
     *
     * @param  int $parent  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function tree (int $parent = 0) {
        return self::getClass()->tree([
            "parent" => $parent,
        ]);
    }

    /**
     * 创建退款原因
     *
     * @param  string $option 退款原因 [ require true ]
     * @param  int $parent 父级id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (string $option, int $parent = 0) {
        return self::getClass()->create([
            "option" => $option,
            "parent" => $parent,
        ]);
    }

    /**
     * 编辑退款原因
     *
     * @param  int $id 选项id [ require true ]
     * @param  string $option 退款原因 [ require true ]
     * @param  int $parent 父级id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, string $option = '', int $parent = 0) {
        return self::getClass()->update([
            "id" => $id,
            "option" => $option,
            "parent" => $parent,
        ]);
    }

    /**
     * 删除退款原因
     *
     * @param  int $id 退款原因id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'RefundReason');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'RefundReason');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}