<?php
namespace Mainto\Bridge\Invokes\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method removeByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method reapplyByParams(array $params)
 * @method modifyRefundUserByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退款
     *
     * @support  int $himoOrderId 海马体订单id 
     * @support  int $orderId 零售订单id [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  string $reason 退款原因 [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @support  string $from 退款来源:user 用户端， manager 后台 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @support  bool $isStaffPay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $operateId = 0) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 退款列表
     *
     * @support  int $orderId 主订单ID 
     * @support  string $status 状态 
     * @support  int $storeId 门店id 
     * @support  array $storeIds 查询门店数组 
     * @support  int $userId 退款用户id 
     * @support  string $applyTimeStart 申请时间-开始 
     * @support  string $applyTimeEnd 申请时间-结束 
     * @support  string $processTimeStart 处理时间-开始 
     * @support  string $processTimeEnd 处理时间-结束 
     * @support  int $inputStaffId 售出员工ID 
     * @support  int $page  
     * @support  int $pageSize  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId = 0) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 通过退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pass (int $id, int $operateId) {
        return self::getClass()->pass([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $reason 拒绝原因 [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reject (int $id, int $operateId, string $reason = '') {
        return self::getClass()->reject([
            "id" => $id,
            "operateId" => $operateId,
            "reason" => $reason,
        ]);
    }

    /**
     * 重新申请退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $people 退款人 [ require true ]
     * @param  string $account 退款账户 [ require true ]
     * @param  string $reason 退款原因 [ require true ]
     * @param  int $inputStaffId 录入人伙伴ID [ require true ]
     * @param  int $operateId 操作伙伴ID(后台操作时必须添加) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reapply (int $id, string $people, string $account, string $reason, int $inputStaffId = 0, int $operateId = 0) {
        return self::getClass()->reapply([
            "id" => $id,
            "people" => $people,
            "account" => $account,
            "reason" => $reason,
            "inputStaffId" => $inputStaffId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改信息
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $people 退款人 [ require true ]
     * @param  string $account 退款账户 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyRefundUser (int $id, string $people = '', string $account = '') {
        return self::getClass()->modifyRefundUser([
            "id" => $id,
            "people" => $people,
            "account" => $account,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('RetailOrder', 'Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('RetailOrder', 'Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}