<?php
namespace Mainto\Bridge\Invokes\ReservationTable;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method batchCancelByParams(array $params)
 * @method getInfoByCertificateByParams(array $params)
 * @method getRecordsByCertificatesByParams(array $params)
 */
class PreReservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建预占点
     *
     * @param  array $demands 占点需求 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $demands) {
        return self::getClass()->batchCreate([
            "demands" => $demands,
        ]);
    }

    /**
     * 取消占点
     *
     * @param  array $certificates 凭证s [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCancel (array $certificates) {
        return self::getClass()->batchCancel([
            "certificates" => $certificates,
        ]);
    }

    /**
     * 根据凭证获取记录
     *
     * @param  string $certificate 凭证 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfoByCertificate (string $certificate) {
        return self::getClass()->getInfoByCertificate([
            "certificate" => $certificate,
        ]);
    }

    /**
     * 根据凭证s获取记录
     *
     * @param  array $certificates 凭证s [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRecordsByCertificates (array $certificates) {
        return self::getClass()->getRecordsByCertificates([
            "certificates" => $certificates,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ReservationTable', 'PreReservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ReservationTable', 'PreReservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}