<?php
namespace Mainto\Bridge\Invokes\ReservationTable;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method cancelByParams(array $params)
 * @method getPreReservationInfoByParams(array $params)
 */
class PreReservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建预占点
     *
     * @support  array $demands 占点需求 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context) {
        return self::getClass()->create([
            "context" => $context,
        ]);
    }

    /**
     * 取消占点
     *
     * @param  string $certificate 凭证 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (string $certificate) {
        return self::getClass()->cancel([
            "certificate" => $certificate,
        ]);
    }

    /**
     * 获取预占点信息
     *
     * @param  string $certificate 凭证 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreReservationInfo (string $certificate) {
        return self::getClass()->getPreReservationInfo([
            "certificate" => $certificate,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ReservationTable', 'PreReservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ReservationTable', 'PreReservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}