<?php
namespace Mainto\Bridge\Invokes\ReservationTable;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setReservationByParams(array $params)
 * @method changReserveTimeByParams(array $params)
 * @method changeOrderTimeByParams(array $params)
 * @method restoreBatchCloseByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method cancelReservationByParams(array $params)
 * @method batchSwitchReservationByParams(array $params)
 * @method transferStoreReservationByParams(array $params)
 * @method getListByParams(array $params)
 * @method getReservationListByParams(array $params)
 * @method emptyReservationByParams(array $params)
 * @method updateServiceTimesByParams(array $params)
 * @method releaseEmptyPointByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置排单信息
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  int $order_id 订单id [ require true ]
     * @param  string $state 位置的状态 [ require true ]
     * @param  string $order_time 预约时间 [ require true ]
     * @param  int $index 预约位置索引(有位置索引以索引为准) [ require true ]
     * @param  int $occupy_num 占位数 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setReservation (int $store_id, string $state, string $order_time, int $order_id = NULL, int $index = NULL, int $occupy_num = 1, string $type = 'shoot_picture') {
        return self::getClass()->setReservation([
            "store_id" => $store_id,
            "state" => $state,
            "order_time" => $order_time,
            "order_id" => $order_id,
            "index" => $index,
            "occupy_num" => $occupy_num,
            "type" => $type,
        ]);
    }

    /**
     * 更改预约时间
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $orderId 订单id [ require true ]
     * @support  string $originReserveTime 原始预约时间 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @support  int $index 预约位置索引(有位置索引以索引为准) 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changReserveTime () {
        return self::getClass()->changReserveTime();
    }

    /**
     * 更改预约时间
     * @deprecated
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @support  string $origin_time 原时间 [ require true ]
     * @support  string $order_time 预约时间 [ require true ]
     * @support  int $index 预约位置索引(有位置索引以索引为准) 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderTime () {
        return self::getClass()->changeOrderTime();
    }

    /**
     * 恢复批量关闭
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  array $close_list 关闭节点 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function restoreBatchClose (int $store_id, array $close_list, string $type) {
        return self::getClass()->restoreBatchClose([
            "store_id" => $store_id,
            "close_list" => $close_list,
            "type" => $type,
        ]);
    }

    /**
     * 批量关闭
     *
     * @support  string $date_begin 日期起 [ require true ]
     * @support  string $date_end 日期止 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  string $time_begin 时间起 [ require true ]
     * @support  string $time_end 时间止 [ require true ]
     * @support  int $create_by 创建人 [Original type uint] [ require true ]
     * @support  int $each_time_unset 每时段关闭数 [Original type uint] 
     * @support  bool $is_repeat 是否按日重复关闭 
     * @support  string $reason 原因 [ require true ]
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchClose () {
        return self::getClass()->batchClose();
    }

    /**
     * 取消订单占点
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  string $orderTime 预约时间 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelReservation (int $storeId, int $orderId, string $orderTime, string $type) {
        return self::getClass()->cancelReservation([
            "storeId" => $storeId,
            "orderId" => $orderId,
            "orderTime" => $orderTime,
            "type" => $type,
        ]);
    }

    /**
     * 批量开放|关闭占点
     *
     * @support  string $dateBegin 日期起 [ require true ]
     * @support  string $dateEnd 日期止 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $timeBegin 时间起 [ require true ]
     * @support  string $timeEnd 时间止 [ require true ]
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  int $eachTimeUnset 每时段开|关数 [Original type uint] 
     * @support  bool $isRepeat 是否按日重复关闭 
     * @support  string $reason 原因 [ require true ]
     * @support  string $state 状态 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSwitchReservation () {
        return self::getClass()->batchSwitchReservation();
    }

    /**
     * 转门店排单
     *
     * @support  int $originOrderId 原订单ID [Original type uint] [ require true ]
     * @support  int $originStoreId 原门店id [Original type uint] [ require true ]
     * @support  string $originReserveTime 原预约时间 [ require true ]
     * @support  int $orderId 订单ID [Original type uint] [ require true ]
     * @support  int $storeId 转门店id [Original type uint] [ require true ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $index 预约位置索引(有位置索引以索引为准) [Original type uint] 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function transferStoreReservation () {
        return self::getClass()->transferStoreReservation();
    }

    /**
     * 获取排单列表
     * @deprecated
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  string $date_start 日期起 [ require true ]
     * @param  string $date_end 日期止 (default today) [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $store_id, string $date_start, string $date_end, string $type) {
        return self::getClass()->getList([
            "store_id" => $store_id,
            "date_start" => $date_start,
            "date_end" => $date_end,
            "type" => $type,
        ]);
    }

    /**
     * 获取排单列表
     *
     * @support  int $storeId 门店id [Original type uint] 
     * @support  array $storeIds 门店id [Original type array&lt;uint&gt;] 
     * @support  string $dateStart 日期起 
     * @support  string $dateEnd 日期止 (default today) 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  array
     */
    public static function getReservationList () {
        return self::getClass()->getReservationList();
    }

    /**
     * 清空排单表
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  string $start_date 排单表 [ require true ]
     * @param  string $end_date 排单表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function emptyReservation (int $store_id, string $start_date, string $end_date) {
        return self::getClass()->emptyReservation([
            "store_id" => $store_id,
            "start_date" => $start_date,
            "end_date" => $end_date,
        ]);
    }

    /**
     * 更新每间隔同时服务数
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  string $effectDate 生效日期 [ require true ]
     * @param  int $appendLines 影响行数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateServiceTimes (int $storeId, string $effectDate, int $appendLines) {
        return self::getClass()->updateServiceTimes([
            "storeId" => $storeId,
            "effectDate" => $effectDate,
            "appendLines" => $appendLines,
        ]);
    }

    /**
     * 释放无订单占点
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  string $endDate 截止时间 [ require true ]
     * @param  string $startDate 开始时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function releaseEmptyPoint (int $storeId, string $endDate, string $startDate) {
        return self::getClass()->releaseEmptyPoint([
            "storeId" => $storeId,
            "endDate" => $endDate,
            "startDate" => $startDate,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ReservationTable', 'Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ReservationTable', 'Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}