<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Training;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createTrainPlanByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreateBaseConfigCmd $params)
 * @method editTrainPlanByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\EditBaseConfigCmd $params)
 * @method delTrainPlanByParams(array $params)
 * @method createPassConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $params)
 * @method editPassConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $params)
 * @method getTrainPlanDetailByParams(array $params)
 * @method getTrainPlanListByParams(array $params)
 * @method createLearningPlanByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $params)
 * @method getTrainPlanIdsByStateByParams(array $params)
 */
class TrainPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createTrainPlan
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreateBaseConfigCmd $trainPlanCmd
     * @throws  \Exception
     * @return  int
     */
    public static function createTrainPlan (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreateBaseConfigCmd $trainPlanCmd) {
        return self::getClass()->createTrainPlan($trainPlanCmd);
    }


    /**
     * editTrainPlan
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\EditBaseConfigCmd $trainPlanCmd
     * @throws  \Exception
     * @return  int
     */
    public static function editTrainPlan (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\EditBaseConfigCmd $trainPlanCmd) {
        return self::getClass()->editTrainPlan($trainPlanCmd);
    }


    /**
     * delTrainPlan
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delTrainPlan (int $id) {
        return self::getClass()->delTrainPlan([
            "id" => $id,
        ]);
    }

    /**
     * createPassConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $passConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createPassConfig (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $passConfigCmd) {
        return self::getClass()->createPassConfig($passConfigCmd);
    }


    /**
     * editPassConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $passConfigCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editPassConfig (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $passConfigCmd) {
        return self::getClass()->editPassConfig($passConfigCmd);
    }


    /**
     * getTrainPlanDetail
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\TrainPlanDTO
     */
    public static function getTrainPlanDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTrainPlanDetail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\TrainPlanDTO"
        );
    }

    /**
     * getTrainPlanList
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  string $titleLike 计划标题查询 [ require false ]
     * @support  array $stateIn 状态 [ require false ]
     * @support  array $typeIn 类型 [ require false ]
     * @support  int $mentorId 类型 [ require false ]
     * @support  int $page page [ require false ]
     * @support  int $pageSize pageSize [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\TrainPlanListDTO
     */
    public static function getTrainPlanList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTrainPlanList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\TrainPlanListDTO"
        );
    }

    /**
     * 监听创建NPS记录
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $passConfigCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createLearningPlan (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\PassConfigCmd $passConfigCmd) {
        return self::getClass()->createLearningPlan($passConfigCmd);
    }


    /**
     * getTrainPlanIdsByState
     *
     * @param  array $stateIn 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTrainPlanIdsByState (array $stateIn) {
        return self::getClass()->getTrainPlanIdsByState([
            "stateIn" => $stateIn,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Training\TrainPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Training\TrainPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}