<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Training;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailWithExamByParams(array $params)
 * @method learningPlanListByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $params)
 * @method learningPlanStateByCountByParams(array $params)
 * @method getStaffWithMentorIdsByParams(array $params)
 * @method getStaffLearningPlanCountMapByParams(array $params)
 * @method learningPlanStartByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanOperateCmd $params)
 * @method learningPlanEndStudyByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanOperateCmd $params)
 * @method hasProcessingPlanByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\SessionStaffCmd $params)
 * @method hasWaitExamPlanByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\SessionStaffCmd $params)
 * @method openLearningPlanByParams(array $params)
 * @method closePlanByParams(array $params)
 */
class LearningPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取学习计划详情
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanDetailDTO
     */
    public static function detailWithExam (int $learningPlanId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailWithExam([
                            "learningPlanId" => $learningPlanId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanDetailDTO"
        );
    }

    /**
     * 获取学习计划列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanListDTO
     */
    public static function learningPlanList (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->learningPlanList($cmd),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanListDTO"
        );
    }


    /**
     * learningPlanStateByCount
     *
     * @param  array $trainPlanIds 计划ids [ require true ]
     * @param  array $stateIn 状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function learningPlanStateByCount (array $trainPlanIds, array $stateIn = []) {
        return self::getClass()->learningPlanStateByCount([
            "trainPlanIds" => $trainPlanIds,
            "stateIn" => $stateIn,
        ]);
    }

    /**
     * getStaffWithMentorIds
     *
     * @param  int $trainPlanId 计划ids [ require true ]
     * @param  array $stateIn 状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffWithMentorIds (int $trainPlanId, array $stateIn = []) {
        return self::getClass()->getStaffWithMentorIds([
            "trainPlanId" => $trainPlanId,
            "stateIn" => $stateIn,
        ]);
    }

    /**
     * 获取某人学习计划数量 -- 类别分类
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  array $stateIn 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffLearningPlanCountMap (int $staffId, array $stateIn) {
        return self::getClass()->getStaffLearningPlanCountMap([
            "staffId" => $staffId,
            "stateIn" => $stateIn,
        ]);
    }

    /**
     * 开始学习计划
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanOperateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function learningPlanStart (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanOperateCmd $cmd) {
        return self::getClass()->learningPlanStart($cmd);
    }


    /**
     * 学习计划学习完成
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanOperateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function learningPlanEndStudy (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanOperateCmd $cmd) {
        return self::getClass()->learningPlanEndStudy($cmd);
    }


    /**
     * 是否存在处理中的学习计划
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\SessionStaffCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hasProcessingPlan (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\SessionStaffCmd $cmd) {
        return self::getClass()->hasProcessingPlan($cmd);
    }


    /**
     * 是否存在需要重考的学习计划
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\SessionStaffCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function hasWaitExamPlan (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\SessionStaffCmd $cmd) {
        return self::getClass()->hasWaitExamPlan($cmd);
    }


    /**
     * 开放学习计划
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function openLearningPlan () {
        return self::getClass()->openLearningPlan();
    }

    /**
     * 关闭学习计划与培训计划
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function closePlan () {
        return self::getClass()->closePlan();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Training\LearningPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Training\LearningPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}