<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Training;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getExamScoreSignByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\ExamSignDataCmd $params)
 */
class TrainingData {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getExamScoreSign
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\ExamSignDataCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ScoreConfigListWithAggDTO
     */
    public static function getExamScoreSign (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\ExamSignDataCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getExamScoreSign($cmd),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ScoreConfigListWithAggDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Training\TrainingData');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Training\TrainingData');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}