<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Exam;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method learningPlanSubmitPaperByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\SubmitPaperCmd $params)
 * @method getExamRecordWithPapersByParams(array $params)
 * @method startLearningPlanExamByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\LearningPlanStartExamCmd $params)
 * @method startPaperByParams(array $params)
 * @method learningPlanStartPaperByParams(array $params)
 * @method getPaperDetailByParams(array $params)
 * @method markPaperByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\MarkPaperCmd $params)
 * @method learningPlanMarkPaperByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\MarkPaperCmd $params)
 * @method learningPlanBindMarkByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanBindMarkCmd $params)
 */
class Exam {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 学习计划提交试卷
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\SubmitPaperCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO
     */
    public static function learningPlanSubmitPaper (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\SubmitPaperCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->learningPlanSubmitPaper($cmd),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO"
        );
    }


    /**
     * 获取考核记录与试卷
     *
     * @param  string $examRecordId 考核记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO
     */
    public static function getExamRecordWithPapers (string $examRecordId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getExamRecordWithPapers([
                            "examRecordId" => $examRecordId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO"
        );
    }

    /**
     * 开始学习计划考核
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\LearningPlanStartExamCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO
     */
    public static function startLearningPlanExam (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\LearningPlanStartExamCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->startLearningPlanExam($cmd),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO"
        );
    }


    /**
     * 开始一张试卷
     *
     * @param  string $paperId 试卷id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function startPaper (string $paperId) {
        return self::getClass()->startPaper([
            "paperId" => $paperId,
        ]);
    }

    /**
     * 学习计划开始一张试卷
     *
     * @param  string $paperId 试卷id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function learningPlanStartPaper (string $paperId) {
        return self::getClass()->learningPlanStartPaper([
            "paperId" => $paperId,
        ]);
    }

    /**
     * 获取试卷详情
     *
     * @param  string $paperId 试卷id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\PaperDetailDTO
     */
    public static function getPaperDetail (string $paperId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPaperDetail([
                            "paperId" => $paperId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\PaperDetailDTO"
        );
    }

    /**
     * 阅卷接口
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\MarkPaperCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\PaperDetailDTO
     */
    public static function markPaper (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\MarkPaperCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->markPaper($cmd),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\PaperDetailDTO"
        );
    }


    /**
     * 学习计划阅卷接口
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\MarkPaperCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\PaperDetailDTO
     */
    public static function learningPlanMarkPaper (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\MarkPaperCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->learningPlanMarkPaper($cmd),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\PaperDetailDTO"
        );
    }


    /**
     * 学习计划绑定阅卷导师
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanBindMarkCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function learningPlanBindMark (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanBindMarkCmd $cmd) {
        return self::getClass()->learningPlanBindMark($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Exam\Exam');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Exam\Exam');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}