<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Training;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailWithExamByParams(array $params)
 * @method learningPlanListByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $params)
 * @method learningPlanStateCountByParams(array $params)
 */
class LearningPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * detailWithExam
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanWithExamDTO
     */
    public static function detailWithExam (int $learningPlanId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detailWithExam([
                            "learningPlanId" => $learningPlanId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanWithExamDTO"
        );
    }

    /**
     * learningPlanList
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanListDTO
     */
    public static function learningPlanList (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->learningPlanList($cmd),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanListDTO"
        );
    }


    /**
     * learningPlanStateCount
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function learningPlanStateCount () {
        return self::getClass()->learningPlanStateCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Training\LearningPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Training\LearningPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}