<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Exam;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createExamConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\CreateExamConfigCmd $params)
 * @method editExamConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditExamConfigCmd $params)
 * @method createScoreItemByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\CreateScoreTypeCmd $params)
 * @method editScoreTypeByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditScoreTypeCmd $params)
 * @method editScoreConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditScoreConfigCmd $params)
 */
class ExamConfig {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createExamConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\CreateExamConfigCmd $examConfigCmd
     * @throws  \Exception
     * @return  int
     */
    public static function createExamConfig (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\CreateExamConfigCmd $examConfigCmd) {
        return self::getClass()->createExamConfig($examConfigCmd);
    }


    /**
     * editExamConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditExamConfigCmd $examConfigCmd
     * @throws  \Exception
     * @return  int
     */
    public static function editExamConfig (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditExamConfigCmd $examConfigCmd) {
        return self::getClass()->editExamConfig($examConfigCmd);
    }


    /**
     * createScoreItem
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\CreateScoreTypeCmd $createScoreTypeCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createScoreItem (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\CreateScoreTypeCmd $createScoreTypeCmd) {
        return self::getClass()->createScoreItem($createScoreTypeCmd);
    }


    /**
     * editScoreType
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditScoreTypeCmd $editScoreType
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreType (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditScoreTypeCmd $editScoreType) {
        return self::getClass()->editScoreType($editScoreType);
    }


    /**
     * editScoreConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditScoreConfigCmd $scoreConfigCmd
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreConfig (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\ExamConfig\EditScoreConfigCmd $scoreConfigCmd) {
        return self::getClass()->editScoreConfig($scoreConfigCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Exam\ExamConfig');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Exam\ExamConfig');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}