<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Training;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createTrainPlanByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreateBaseConfigCmd $params)
 * @method editTrainPlanByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\EditBaseConfigCmd $params)
 * @method createPassConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreatePassConfigCmd $params)
 * @method getTrainPlanDetailByParams(array $params)
 */
class TrainPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createTrainPlan
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreateBaseConfigCmd $trainPlanCmd
     * @throws  \Exception
     * @return  int
     */
    public static function createTrainPlan (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreateBaseConfigCmd $trainPlanCmd) {
        return self::getClass()->createTrainPlan($trainPlanCmd);
    }


    /**
     * editTrainPlan
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\EditBaseConfigCmd $trainPlanCmd
     * @throws  \Exception
     * @return  int
     */
    public static function editTrainPlan (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\EditBaseConfigCmd $trainPlanCmd) {
        return self::getClass()->editTrainPlan($trainPlanCmd);
    }


    /**
     * createPassConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreatePassConfigCmd $createPassConfigCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPassConfig (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\CreatePassConfigCmd $createPassConfigCmd) {
        return self::getClass()->createPassConfig($createPassConfigCmd);
    }


    /**
     * getTrainPlanDetail
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\TrainPlanDTO
     */
    public static function getTrainPlanDetail (int $id) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getTrainPlanDetail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\TrainPlanDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Training\TrainPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Training\TrainPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}