<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Exam;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method submitPaperByParams(array $params)
 * @method getExamRecordWithPapersByParams(array $params)
 * @method startLearningPlanExamByParams(array $params)
 * @method getLearnPlanWithExamRecordListByParams(array $params)
 */
class Exam {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * submitPaper
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitPaper () {
        return self::getClass()->submitPaper();
    }

    /**
     * 获取考核记录与试卷
     *
     * @param  string $examRecordId 考核记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO
     */
    public static function getExamRecordWithPapers (string $examRecordId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getExamRecordWithPapers([
                            "examRecordId" => $examRecordId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO"
        );
    }

    /**
     * 开始学习计划考核
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO
     */
    public static function startLearningPlanExam (int $learningPlanId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->startLearningPlanExam([
                            "learningPlanId" => $learningPlanId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO"
        );
    }

    /**
     * 获取学习计划列表
     *
     * @support  array $staffIdIn 考试人ids [ require false ]
     * @support  array $states 状态 [ require false ]
     * @support  int $trainingPlanId 考核计划id [ require true ]
     * @support  int $markerId 阅卷人id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 页码数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\LearnPlanWithExamRecordListDTO
     */
    public static function getLearnPlanWithExamRecordList ($context) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getLearnPlanWithExamRecordList([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\LearnPlanWithExamRecordListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Exam\Exam');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Exam\Exam');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}