<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Training;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailWithExamByParams(array $params)
 * @method learningPlanListByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $params)
 * @method learningPlanStateByCountByParams(array $params)
 * @method getStaffWithMentorIdsByParams(array $params)
 * @method getStaffLearningPlanCountMapByParams(array $params)
 */
class LearningPlan {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取学习计划详情
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanDetailDTO
     */
    public static function detailWithExam (int $learningPlanId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detailWithExam([
                            "learningPlanId" => $learningPlanId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanDetailDTO"
        );
    }

    /**
     * 获取学习计划列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanListDTO
     */
    public static function learningPlanList (\Mainto\Bridge\Structs\ProjectTrainning\Training\Cmd\LearningPlanListCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->learningPlanList($cmd),
            "\Mainto\Bridge\Structs\ProjectTrainning\Training\DTO\LearningPlanListDTO"
        );
    }


    /**
     * learningPlanStateByCount
     *
     * @param  array $trainPlanIds 计划ids [ require true ]
     * @param  array $stateIn 状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function learningPlanStateByCount (array $trainPlanIds, array $stateIn = []) {
        return self::getClass()->learningPlanStateByCount([
            "trainPlanIds" => $trainPlanIds,
            "stateIn" => $stateIn,
        ]);
    }

    /**
     * getStaffWithMentorIds
     *
     * @param  int $trainPlanId 计划ids [ require true ]
     * @param  array $stateIn 状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffWithMentorIds (int $trainPlanId, array $stateIn = []) {
        return self::getClass()->getStaffWithMentorIds([
            "trainPlanId" => $trainPlanId,
            "stateIn" => $stateIn,
        ]);
    }

    /**
     * 获取某人学习计划数量
     *
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffLearningPlanCountMap (int $staffId) {
        return self::getClass()->getStaffLearningPlanCountMap([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Training\LearningPlan');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Training\LearningPlan');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}