<?php
namespace Mainto\Bridge\Invokes\ProjectTrainning\Exam;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createExamConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateExamConfigCmd $params)
 * @method editExamConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\EditExamConfigCmd $params)
 * @method createScoreTypeByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateScoreTypeCmd $params)
 * @method createScoreConfigByParams(array|\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateScoreConfigCmd $params)
 * @method startLearningPlanExamByParams(array $params)
 * @method submitPaperByParams(array $params)
 */
class Exam {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createExamConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateExamConfigCmd $context
     * @throws  \Exception
     * @return  int
     */
    public static function createExamConfig (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateExamConfigCmd $context) {
        return self::getClass()->createExamConfig($context);
    }


    /**
     * editExamConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\EditExamConfigCmd $examConfigCmd
     * @throws  \Exception
     * @return  int
     */
    public static function editExamConfig (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\EditExamConfigCmd $examConfigCmd) {
        return self::getClass()->editExamConfig($examConfigCmd);
    }


    /**
     * createScoreType
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateScoreTypeCmd $createScoreTypeCmd
     * @throws  \Exception
     * @return  int
     */
    public static function createScoreType (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateScoreTypeCmd $createScoreTypeCmd) {
        return self::getClass()->createScoreType($createScoreTypeCmd);
    }


    /**
     * createScoreConfig
     *
     * @var  \Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateScoreConfigCmd $createScoreConfigCmd
     * @throws  \Exception
     * @return  int
     */
    public static function createScoreConfig (\Mainto\Bridge\Structs\ProjectTrainning\Exam\Cmd\CreateScoreConfigCmd $createScoreConfigCmd) {
        return self::getClass()->createScoreConfig($createScoreConfigCmd);
    }


    /**
     * 开始学习计划考核
     *
     * @param  int $learningPlanId 学习计划id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO
     */
    public static function startLearningPlanExam (int $learningPlanId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->startLearningPlanExam([
                            "learningPlanId" => $learningPlanId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectTrainning\Exam\DTO\ExamRecordWithPapersDTO"
        );
    }

    /**
     * submitPaper
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitPaper () {
        return self::getClass()->submitPaper();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTrainning', 'Exam\Exam');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTrainning', 'Exam\Exam');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}