<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-26 18:11:16
 */
namespace Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Order;

class RefundInfoDTO {
    /**
     * @var  array
     * 退款信息，结构类型和订单的RefundInfoCommand一致
     * validation: 
     */
    public array $refundInfo;
    /**
     * @var  string
     * orderSaleSku退款手续费，单位：元
     * validation: 
     */
    public string $saleCommissionMoney;
    /**
     * @var  int
     * 退款手续费比例，100或85
     * validation: 
     */
    public int $scale;
    /**
     * @var  bool
     * 是否直接退款，月初和月末这两天，财务不处理，返回false，其余时间返回true
     * validation: 
     */
    public bool $refundDirect;

    public function __construct (array $refundInfo = [], string $saleCommissionMoney = '', int $scale = 0, bool $refundDirect = false) {
        if (!is_null($refundInfo)) {
            $this->refundInfo = $refundInfo;
        }
        if (!is_null($saleCommissionMoney)) {
            $this->saleCommissionMoney = $saleCommissionMoney;
        }
        if (!is_null($scale)) {
            $this->scale = $scale;
        }
        if (!is_null($refundDirect)) {
            $this->refundDirect = $refundDirect;
        }
    }

    public static function create(array $refundInfo = [], string $saleCommissionMoney = '', int $scale = 0, bool $refundDirect = false): self {
        return new self($refundInfo, $saleCommissionMoney, $scale, $refundDirect);
    }

    public function setRefundInfo(array $refundInfo): self {
        $this->refundInfo = $refundInfo;

        return $this;
    }

    public function setSaleCommissionMoney(string $saleCommissionMoney): self {
        $this->saleCommissionMoney = $saleCommissionMoney;

        return $this;
    }

    public function setScale(int $scale): self {
        $this->scale = $scale;

        return $this;
    }

    public function setRefundDirect(bool $refundDirect): self {
        $this->refundDirect = $refundDirect;

        return $this;
    }
}