<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-16 14:10:51
 */
namespace Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\MultiReservation;

class DateReservationDTO {
    /**
     * @var  string
     * 日期，格式Y-m-d
     * validation: 
     */
    public string $date;
    /**
     * @var  bool
     * 是否周间日期
     * validation: 
     */
    public bool $isWeekDay;
    /**
     * @var  bool
     * 是否为若来引流日. 已废弃
     * validation: 
     */
    public bool $isRolifeDay = false;
    /**
     * @var  null|string
     * icon类型. 已废弃
     * validation: 
     */
    public ?string $iconType = null;
    /**
     * @var  bool
     * 是否是活动日
     * validation: 
     */
    public bool $isActivityDay = false;
    /**
     * @var  string[]
     * 活动icon类型
     * validation: 
     */
    public array $iconTypes = [];
    /**
     * @var  string
     * 状态，available 可拍/noavailable 没有可拍点位,详见ReservationDayStatusEnum
     * validation: 
     */
    public string $status = "available";
    /**
     * @var  null|string
     * 优惠金额 格式:字符串类型的数字
     * validation: 
     */
    public ?string $discountAmount;
    /**
     * @var  null|string
     * 日期类型 workday/holiday | null
     * validation: 
     */
    public ?string $dateType;
    /**
     * @var  null|\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Common\TemplateContentDTO
     * 提示-模板内容
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Common\TemplateContentDTO $templateContent = null;
    /**
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\StoreReservation\StoreReservationListDTO[]
     * 门店列表
     * validation: 
     */
    public array $storeReservationList;

    public function __construct (string $date = '', bool $isWeekDay = false, ?string $discountAmount = '', ?string $dateType = '', array $storeReservationList = []) {
        if (!is_null($date)) {
            $this->date = $date;
        }
        if (!is_null($isWeekDay)) {
            $this->isWeekDay = $isWeekDay;
        }
        if (!is_null($discountAmount)) {
            $this->discountAmount = $discountAmount;
        }
        if (!is_null($dateType)) {
            $this->dateType = $dateType;
        }
        if (!is_null($storeReservationList)) {
            $this->storeReservationList = $storeReservationList;
        }
    }

    public static function create(string $date = '', bool $isWeekDay = false, ?string $discountAmount = '', ?string $dateType = '', array $storeReservationList = []): self {
        return new self($date, $isWeekDay, $discountAmount, $dateType, $storeReservationList);
    }

    public function setDate(string $date): self {
        $this->date = $date;

        return $this;
    }

    public function setIsWeekDay(bool $isWeekDay): self {
        $this->isWeekDay = $isWeekDay;

        return $this;
    }

    public function setIsRolifeDay(bool $isRolifeDay): self {
        $this->isRolifeDay = $isRolifeDay;

        return $this;
    }

    public function setIconType(?string $iconType): self {
        $this->iconType = $iconType;

        return $this;
    }

    public function setIsActivityDay(bool $isActivityDay): self {
        $this->isActivityDay = $isActivityDay;

        return $this;
    }

    public function setIconTypes(array $iconTypes): self {
        $this->iconTypes = $iconTypes;

        return $this;
    }

    public function setStatus(string $status): self {
        $this->status = $status;

        return $this;
    }

    public function setDiscountAmount(?string $discountAmount): self {
        $this->discountAmount = $discountAmount;

        return $this;
    }

    public function setDateType(?string $dateType): self {
        $this->dateType = $dateType;

        return $this;
    }

    public function setTemplateContent(?\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Common\TemplateContentDTO $templateContent): self {
        $this->templateContent = $templateContent;

        return $this;
    }

    public function setStoreReservationList(array $storeReservationList): self {
        $this->storeReservationList = $storeReservationList;

        return $this;
    }
}