<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-31 17:46:15
 */
namespace Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\MultiReservation;

class DateReservationDTO {
    /**
     * @var  string
     * 日期，格式Y-m-d
     * validation: 
     */
    public string $date;
    /**
     * @var  bool
     * 是否周间日期
     * validation: 
     */
    public bool $isWeekDay;
    /**
     * @var  bool
     * 是否为若来引流日. 已废弃
     * validation: 
     */
    public bool $isRolifeDay = false;
    /**
     * @var  null|string
     * icon类型. 已废弃
     * validation: 
     */
    public ?string $iconType = null;
    /**
     * @var  bool
     * 是否是活动日
     * validation: 
     */
    public bool $isActivityDay = false;
    /**
     * @var  string[]
     * 活动icon类型
     * validation: 
     */
    public array $iconTypes = [];
    /**
     * @var  string
     * 状态，available 可拍/noavailable 没有可拍点位,详见ReservationDayStatusEnum
     * validation: 
     */
    public string $status = "available";
    /**
     * @var  null|\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Common\TemplateContentDTO
     * 
     * validation: 
     */
    public ?\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Common\TemplateContentDTO $templateContent = null;
    /**
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\StoreReservation\StoreReservationListDTO[]
     * 门店列表
     * validation: 
     */
    public array $storeReservationList;

    public function __construct (string $date = '', bool $isWeekDay = false, array $storeReservationList = []) {
        if (!is_null($date)) {
            $this->date = $date;
        }
        if (!is_null($isWeekDay)) {
            $this->isWeekDay = $isWeekDay;
        }
        if (!is_null($storeReservationList)) {
            $this->storeReservationList = $storeReservationList;
        }
    }

    public static function create(string $date = '', bool $isWeekDay = false, array $storeReservationList = []): self {
        return new self($date, $isWeekDay, $storeReservationList);
    }

    public function setDate(string $date): self {
        $this->date = $date;

        return $this;
    }

    public function setIsWeekDay(bool $isWeekDay): self {
        $this->isWeekDay = $isWeekDay;

        return $this;
    }

    public function setIsRolifeDay(bool $isRolifeDay): self {
        $this->isRolifeDay = $isRolifeDay;

        return $this;
    }

    public function setIconType(?string $iconType): self {
        $this->iconType = $iconType;

        return $this;
    }

    public function setIsActivityDay(bool $isActivityDay): self {
        $this->isActivityDay = $isActivityDay;

        return $this;
    }

    public function setIconTypes(array $iconTypes): self {
        $this->iconTypes = $iconTypes;

        return $this;
    }

    public function setStatus(string $status): self {
        $this->status = $status;

        return $this;
    }

    public function setTemplateContent(?\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Common\TemplateContentDTO $templateContent): self {
        $this->templateContent = $templateContent;

        return $this;
    }

    public function setStoreReservationList(array $storeReservationList): self {
        $this->storeReservationList = $storeReservationList;

        return $this;
    }
}