<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-28 19:01:14
 */
namespace Mainto\Bridge\Invokes\ProjectTradeDomain\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductMessageQueue
 */
class ProductMessageQueue {
    private static string $serviceName = "ProjectTradeDomain";

    private static string $className = "MessageQueue\\ProductMessageQueue";

    /**
     * 更新产品事件
     */
    public static function listenProductChange (int $productId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenProductChange(["productId" => $productId, ]);
    }
    /**
     * 更新产品组事件
     */
    public static function listenProductCategoryChange (int $categoryId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenProductCategoryChange(["categoryId" => $categoryId, ]);
    }
    /**
     * 更新门店禁用产品事件
     */
    public static function listenStoreBlackListChange (array $productIds, array $storeIds = []): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenStoreBlackListChange(["productIds" => $productIds, "storeIds" => $storeIds, ]);
    }
    /**
     * 更新产品价格事件
     */
    public static function listenProductPriceChange (int $productId, int $priceId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenProductPriceChange(["productId" => $productId, "priceId" => $priceId, ]);
    }
    /**
     * 更新产品价格区事件
     */
    public static function listenProductPriceAreaChange (int $priceId, array $areaIds = []): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenProductPriceAreaChange(["priceId" => $priceId, "areaIds" => $areaIds, ]);
    }
    /**
     * 更新门店价格区事件
     */
    public static function listenStorePriceAreaChange (int $priceAreaId, array $storeIds = []): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenStorePriceAreaChange(["priceAreaId" => $priceAreaId, "storeIds" => $storeIds, ]);
    }
    /**
     * 套餐上架事件
     */
    public static function listenPackageUp (int $packageId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenPackageUp(["packageId" => $packageId, ]);
    }
    /**
     * 套餐下架事件
     */
    public static function listenPackageDown (int $packageId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenPackageDown(["packageId" => $packageId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}