<?php
namespace Mainto\Bridge\Invokes\ProjectTradeDomain\Third;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method preOrderCreateCallbackByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $params)
 * @method preOrderRefundCallbackByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $params)
 * @method orderRefundResultCallbackByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $params)
 */
class DouYinCallback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预下单回调
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback
     * @throws  \Exception
     * @return  string
     */
    public static function preOrderCreateCallback (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback) {
        return self::getClass()->preOrderCreateCallback($callback);
    }


    /**
     * 退款创建回调
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback
     * @throws  \Exception
     * @return  string
     */
    public static function preOrderRefundCallback (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback) {
        return self::getClass()->preOrderRefundCallback($callback);
    }


    /**
     * 退款结果回调
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback
     * @throws  \Exception
     * @return  string
     */
    public static function orderRefundResultCallback (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback) {
        return self::getClass()->orderRefundResultCallback($callback);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTradeDomain', 'Third\DouYinCallback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTradeDomain', 'Third\DouYinCallback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}