<?php
namespace Mainto\Bridge\Invokes\ProjectTradeDomain\Third;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderCreateCallbackByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $params)
 * @method orderRefundCallbackByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $params)
 */
class DouYinCallback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 下单回调
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback
     * @throws  \Exception
     * @return  string
     */
    public static function orderCreateCallback (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback) {
        return self::getClass()->orderCreateCallback($callback);
    }


    /**
     * 退款回调
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback
     * @throws  \Exception
     * @return  string
     */
    public static function orderRefundCallback (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Third\DouYinCallbackCmd $callback) {
        return self::getClass()->orderRefundCallback($callback);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTradeDomain', 'Third\DouYinCallback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTradeDomain', 'Third\DouYinCallback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}