<?php
namespace Mainto\Bridge\Invokes\ProjectTradeDomain\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method infoByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Index\HealthCMD $params)
 */
class Health {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 健康检查
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Index\HealthCMD $healthCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Index\HealthDTO
     */
    public static function info (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Index\HealthCMD $healthCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info($healthCmd),
            "\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Index\HealthDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTradeDomain', 'Index\Health');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTradeDomain', 'Index\Health');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}