<?php
namespace Mainto\Bridge\Invokes\ProjectTradeDomain\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenProductChangeByParams(array $params)
 * @method listenProductCategoryChangeByParams(array $params)
 * @method listenStoreBlackListChangeByParams(array $params)
 * @method listenProductPriceChangeByParams(array $params)
 * @method listenProductPriceAreaChangeByParams(array $params)
 * @method listenStorePriceAreaChangeByParams(array $params)
 * @method listenPackageUpByParams(array $params)
 * @method listenPackageDownByParams(array $params)
 */
class ProductMessageQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新产品事件
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenProductChange (int $productId) {
        return self::getClass()->listenProductChange([
            "productId" => $productId,
        ]);
    }

    /**
     * 更新产品组事件
     *
     * @param  int $categoryId 类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenProductCategoryChange (int $categoryId) {
        return self::getClass()->listenProductCategoryChange([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 更新门店禁用产品事件
     *
     * @param  int $productIds 产品ID [ require true ]
     * @param  array $storeIds 门店IDS [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenStoreBlackListChange (int $productIds, array $storeIds = []) {
        return self::getClass()->listenStoreBlackListChange([
            "productIds" => $productIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 更新产品价格事件
     *
     * @param  int $productId 产品ID [ require true ]
     * @param  int $priceId 价格ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenProductPriceChange (int $productId, int $priceId) {
        return self::getClass()->listenProductPriceChange([
            "productId" => $productId,
            "priceId" => $priceId,
        ]);
    }

    /**
     * 更新产品价格区事件
     *
     * @param  int $priceId 价格ID [ require true ]
     * @param  array $areaIds 区域IDS [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenProductPriceAreaChange (int $priceId, array $areaIds = []) {
        return self::getClass()->listenProductPriceAreaChange([
            "priceId" => $priceId,
            "areaIds" => $areaIds,
        ]);
    }

    /**
     * 更新门店价格区事件
     *
     * @param  int $priceAreaId 产品ID [ require true ]
     * @param  array $storeIds 门店IDS [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenStorePriceAreaChange (int $priceAreaId, array $storeIds = []) {
        return self::getClass()->listenStorePriceAreaChange([
            "priceAreaId" => $priceAreaId,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 套餐上架事件
     *
     * @param  int $packageId 套餐ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenPackageUp (int $packageId) {
        return self::getClass()->listenPackageUp([
            "packageId" => $packageId,
        ]);
    }

    /**
     * 套餐下架事件
     *
     * @param  int $packageId 套餐ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenPackageDown (int $packageId) {
        return self::getClass()->listenPackageDown([
            "packageId" => $packageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTradeDomain', 'MessageQueue\ProductMessageQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTradeDomain', 'MessageQueue\ProductMessageQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}