<?php
namespace Mainto\Bridge\Invokes\ProjectTradeDomain\Reservation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCityReservationListByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CityReservationListCMD $params)
 * @method getStoreReservationListByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\StoreReservationListCMD $params)
 * @method checkReserveTimeByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CheckReservationTimeCMD $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取城市可拍信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CityReservationListCMD $reservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\CityReservation\CityDateReservationDTO
     */
    public static function getCityReservationList (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CityReservationListCMD $reservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCityReservationList($reservationListCmd),
            "\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\CityReservation\CityDateReservationDTO"
        );
    }


    /**
     * 获取门店可拍信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\StoreReservationListCMD $reservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\CityReservation\CityDateReservationDTO
     */
    public static function getStoreReservationList (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\StoreReservationListCMD $reservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreReservationList($reservationListCmd),
            "\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\CityReservation\CityDateReservationDTO"
        );
    }


    /**
     * 验证时间点是否被占用
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CheckReservationTimeCMD $checkReservationTimeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\CheckReserveTimeDTO
     */
    public static function checkReserveTime (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CheckReservationTimeCMD $checkReservationTimeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->checkReserveTime($checkReservationTimeCmd),
            "\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\CheckReserveTimeDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTradeDomain', 'Reservation\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTradeDomain', 'Reservation\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}