<?php
namespace Mainto\Bridge\Invokes\ProjectTradeDomain\Reservation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryMultiReservationListByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\QueryReservationListCMD $params)
 * @method getDateRangeReservationStatByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\QueryReservationListCMD $params)
 * @method checkReserveTimeByParams(array|\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CheckReservationTimeCMD $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询排单列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\QueryReservationListCMD $reservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\MultiReservation\MultiReservationDTO
     */
    public static function queryMultiReservationList (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\QueryReservationListCMD $reservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->queryMultiReservationList($reservationListCmd),
            "\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\MultiReservation\MultiReservationDTO"
        );
    }


    /**
     * 获取时间段排单统计
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\QueryReservationListCMD $reservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\ReservationStat\DateRangeReservationStatDTO
     */
    public static function getDateRangeReservationStat (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\QueryReservationListCMD $reservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDateRangeReservationStat($reservationListCmd),
            "\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\ReservationStat\DateRangeReservationStatDTO"
        );
    }


    /**
     * 验证时间点是否可约
     *
     * @var  \Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CheckReservationTimeCMD $checkReservationTimeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\CheckReserveTimeDTO
     */
    public static function checkReserveTime (\Mainto\Bridge\Structs\ProjectTradeDomain\CMD\Reservation\CheckReservationTimeCMD $checkReservationTimeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->checkReserveTime($checkReservationTimeCmd),
            "\Mainto\Bridge\Structs\ProjectTradeDomain\DTO\Reservation\CheckReserveTimeDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectTradeDomain', 'Reservation\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectTradeDomain', 'Reservation\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}