<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Talent;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\StudentListCmd $params)
 * @method transferPoolByParams(array $params)
 * @method updateTeacherByParams(array $params)
 * @method removeByParams(array $params)
 * @method finishByParams(array $params)
 * @method detailByParams(array $params)
 * @method editByParams(array $params)
 * @method importTeacherByParams(array $params)
 * @method importScoreByParams(array $params)
 * @method exportByParams(array|\Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\StudentExportCmd $params)
 */
class TalentStudent {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 人才池列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\StudentListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\StudentListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\StudentListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\StudentListDTO"
        );
    }


    /**
     * 转移人才池
     *
     * @param  array $studentIds 记录IDs [ require true ]
     * @param  int $pool 目标池 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function transferPool (array $studentIds, int $pool, int $operator) {
        return self::getClass()->transferPool([
            "studentIds" => $studentIds,
            "pool" => $pool,
            "operator" => $operator,
        ]);
    }

    /**
     * 变更带教
     *
     * @param  int $studentId 记录ID [ require true ]
     * @param  int $teacher 带教工号 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTeacher (int $studentId, int $teacher, int $operator) {
        return self::getClass()->updateTeacher([
            "studentId" => $studentId,
            "teacher" => $teacher,
            "operator" => $operator,
        ]);
    }

    /**
     * 删除人才池
     *
     * @param  array $studentIds 记录IDs [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function remove (array $studentIds, int $operator) {
        return self::getClass()->remove([
            "studentIds" => $studentIds,
            "operator" => $operator,
        ]);
    }

    /**
     * 确认完成
     *
     * @param  array $studentIds 记录ids [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function finish (array $studentIds, int $operator) {
        return self::getClass()->finish([
            "studentIds" => $studentIds,
            "operator" => $operator,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $studentId 记录ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\StudentDetailDTO
     */
    public static function detail (int $studentId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "studentId" => $studentId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\StudentDetailDTO"
        );
    }

    /**
     * 编辑
     *
     * @param  int $staffId 记录ID [ require true ]
     * @param  string $stage 所属期数 [ require true ]
     * @support  array $basicInfo 基础信息 [ require false ]
     * @support  array $poolInfo 池信息 [ require false ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function edit (int $staffId, string $stage, int $operator) {
        return self::getClass()->edit([
            "staffId" => $staffId,
            "stage" => $stage,
            "operator" => $operator,
        ]);
    }

    /**
     * 导入带教
     *
     * @param  array $data 导入数据 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTeacher (array $data, int $operator) {
        return self::getClass()->importTeacher([
            "data" => $data,
            "operator" => $operator,
        ]);
    }

    /**
     * 导入成绩
     *
     * @param  array $data 导入数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importScore (array $data) {
        return self::getClass()->importScore([
            "data" => $data,
        ]);
    }

    /**
     * 数据导出
     *
     * @var  \Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\StudentExportCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function export (\Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\StudentExportCmd $cmd) {
        return self::getClass()->export($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Talent\TalentStudent');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Talent\TalentStudent');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}