<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Talent;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\RiskListCmd $params)
 * @method importByParams(array $params)
 * @method clearByParams(array $params)
 */
class TalentRisk {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 报名列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\RiskListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\RiskListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\RiskListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\RiskListDTO"
        );
    }


    /**
     * 导入
     *
     * @param  array $data 导入数据 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function import (array $data, int $operator) {
        return self::getClass()->import([
            "data" => $data,
            "operator" => $operator,
        ]);
    }

    /**
     * 清空
     *
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clear (int $operator) {
        return self::getClass()->clear([
            "operator" => $operator,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Talent\TalentRisk');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Talent\TalentRisk');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}