<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\WishCastle;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method editByParams(array $params)
 * @method getGiftListByParams(array $params)
 * @method releaseGiftByParams(array $params)
 */
class Gift {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建礼物
     *
     * @support  string $type_id 愿望类型id [ require true ]
     * @support  string $gift_name 礼物名称 [ require false ]
     * @support  string $gift_detail 礼物介绍 [ require true ]
     * @support  array $images 图片 [ require true ]
     * @support  int $score 兑换所需 [ require true ]
     * @support  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑礼物
     *
     * @support  string $_id id [ require true ]
     * @support  string $type_id 礼物类别 [ require false ]
     * @support  string $gift_name 礼物名称 [ require false ]
     * @support  string $gift_detail 礼物介绍 [ require false ]
     * @support  array $images 图片 [ require false ]
     * @support  int $score 兑换所需 [ require false ]
     * @support  string $state 状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function edit () {
        return self::getClass()->edit([
        ]);
    }

    /**
     * 礼物列表
     *
     * @support  string $type_id 礼物类别 [ require false ]
     * @support  string $gift_name 礼物名称 [ require false ]
     * @support  string $creator 提交人姓名 [ require false ]
     * @support  string $state 状态位 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGiftList () {
        return self::getClass()->getGiftList([
        ]);
    }

    /**
     * 上架/下架
     *
     * @param  string $gift_id 礼物id [ require true ]
     * @param  string $state 状态【是否上架】 [ require true ]
     * @param  int $score 礼物分值 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function releaseGift (string $gift_id, string $state, int $score = 0) {
        return self::getClass()->releaseGift([
            "gift_id" => $gift_id,
            "state" => $state,
            "score" => $score,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\WishCastle\Gift');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\WishCastle\Gift');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}