<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method releaseStatusByParams(array $params)
 * @method deleteByParams(array $params)
 * @method existsByParams(array $params)
 */
class Banner {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建banner
     *
     * @param  string $title 标题 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $info 内容 [ require true ]
     * @param  string $cover 封面图 [ require false ]
     * @param  string $link 链接 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $title, string $type, string $info, string $cover = null, string $link = null) {
        return self::getClass()->create([
            "title" => $title,
            "type" => $type,
            "info" => $info,
            "cover" => $cover,
            "link" => $link,
        ]);
    }

    /**
     * 修改banner
     *
     * @param  int $id id [ require true ]
     * @param  string $title 标题 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $info 内容 [ require true ]
     * @param  string $cover 封面图 [ require false ]
     * @param  string $link 链接 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id, string $title, string $type, string $info, string $cover = null, string $link = null) {
        return self::getClass()->update([
            "id" => $id,
            "title" => $title,
            "type" => $type,
            "info" => $info,
            "cover" => $cover,
            "link" => $link,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $title 标题 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $type 状态 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 上下线
     *
     * @param  int $id id [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function releaseStatus (int $id, string $status) {
        return self::getClass()->releaseStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 标题是否存在
     *
     * @param  string $title 标题 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function exists (string $title) {
        return self::getClass()->exists([
            "title" => $title,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\SpaceStation\Banner');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\SpaceStation\Banner');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}