<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Talent;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\QueryAllCmd $params)
 * @method deleteByParams(array $params)
 * @method putIntoStudentPoolByParams(array $params)
 * @method importByParams(array $params)
 */
class TalentRegister {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 报名列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\QueryAllCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\RegisterListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectThinking\Talent\Cmd\QueryAllCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\RegisterListDTO"
        );
    }


    /**
     * 删除报名
     *
     * @param  int $registerId 记录ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $registerId, int $operator) {
        return self::getClass()->delete([
            "registerId" => $registerId,
            "operator" => $operator,
        ]);
    }

    /**
     * 放入人才池
     *
     * @param  int $registerId 记录ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function putIntoStudentPool (int $registerId, int $operator) {
        return self::getClass()->putIntoStudentPool([
            "registerId" => $registerId,
            "operator" => $operator,
        ]);
    }

    /**
     * 导入名单
     *
     * @param  array $data 导入数据 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function import (array $data, int $operator) {
        return self::getClass()->import([
            "data" => $data,
            "operator" => $operator,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Talent\TalentRegister');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Talent\TalentRegister');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}