<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-31 15:23:14
 */
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ThinkManage
 */
class ThinkManage {
    private static string $serviceName = "ProjectThinking";

    private static string $className = "ThinkManage";

    /**
     * 获取脑洞列表
     * @return  mixed
    */
    public static function getThinkList (string $state, string $created_at_start, string $created_at_end, int $staff_num, string $name, string $type_id, string $appraise, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getThinkList(["state" => $state, "created_at_start" => $created_at_start, "created_at_end" => $created_at_end, "staff_num" => $staff_num, "name" => $name, "type_id" => $type_id, "appraise" => $appraise, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 创建脑洞类型
     * @return  mixed
    */
    public static function createType (string $type, int $wish_value) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createType(["type" => $type, "wish_value" => $wish_value]);
    }
    /**
     * 获取脑洞类型
     * @return  mixed
    */
    public static function getThinkType (string $type = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getThinkType(["type" => $type]);
    }
    /**
     * 审核脑洞
     * @return  mixed
    */
    public static function checkThink (array $_ids, string $state, string $un_pass_reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkThink(["_ids" => $_ids, "state" => $state, "un_pass_reason" => $un_pass_reason]);
    }
    /**
     * 修改脑洞
     * @return  mixed
    */
    public static function editThink (array $_ids, string $recommend_reason, string $type_id, array $images) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editThink(["_ids" => $_ids, "recommend_reason" => $recommend_reason, "type_id" => $type_id, "images" => $images]);
    }
    /**
     * 修改脑洞类型
     * @return  mixed
    */
    public static function editType (string $type_id, string $type, int $wish_value) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editType(["type_id" => $type_id, "type" => $type, "wish_value" => $wish_value]);
    }
    /**
     * 脑洞上下架
     * @return  mixed
    */
    public static function releasedThink (string $_id, string $is_released) {
        return RpcClass::getClass(self::$serviceName, self::$className)->releasedThink(["_id" => $_id, "is_released" => $is_released]);
    }
    /**
     * 删除脑洞类型
     * @return  mixed
    */
    public static function delThinkType (string $type_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delThinkType(["type_id" => $type_id]);
    }
    /**
     * 脑洞评选
     * @return  mixed
    */
    public static function thinkAppraise (array $_ids, string $appraise, int $appraiseVal) {
        return RpcClass::getClass(self::$serviceName, self::$className)->thinkAppraise(["_ids" => $_ids, "appraise" => $appraise, "appraiseVal" => $appraiseVal]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}