<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-03 17:46:45
 */
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CouponPhotograph
 */
class CouponPhotograph {
    private static string $serviceName = "ProjectThinking";

    private static string $className = "User\\SpaceStation\\CouponPhotograph";

    /**
     * 拍摄折扣券列表
     * @return  array
    */
    public static function getPhotographCouponList (bool $isActivated = false, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographCouponList(["isActivated" => $isActivated, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 拍摄折扣券详情
     * @return  array
    */
    public static function getPhotographCoupon (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographCoupon(["id" => $id]);
    }
    /**
     * 领取拍摄折扣券
     * @return  array
    */
    public static function activatePhotographCoupon (int $id, string $type, bool $isSelf, string $mobile) {
        return RpcClass::getClass(self::$serviceName, self::$className)->activatePhotographCoupon(["id" => $id, "type" => $type, "isSelf" => $isSelf, "mobile" => $mobile]);
    }
    /**
     * 新伙伴入职发放
     * @return  mixed
    */
    public static function updatePhotographCouponFirstHook (int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePhotographCouponFirstHook(["staff_id" => $staff_id]);
    }
    /**
     * 员工离职删除记录
     * @return  mixed
    */
    public static function deletePhotographCouponFirstHook (int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deletePhotographCouponFirstHook(["staff_id" => $staff_id]);
    }
    /**
     * 员工复职发放
     * @return  mixed
    */
    public static function updatePhotographCouponResignationHook (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePhotographCouponResignationHook(["staffId" => $staffId]);
    }
    /**
     * 发放拍摄折扣券定时任务
     * @return  mixed
    */
    public static function cronPhotographCoupons () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronPhotographCoupons();
    }
    /**
     * 每年给正式员工发放折扣券定时任务
     * @return  bool
    */
    public static function cronPositivePhotographCoupons () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronPositivePhotographCoupons();
    }
    /**
     * 拍摄折扣券删除定时任务
     * @return  mixed
    */
    public static function cronDeletePhotographRecords () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronDeletePhotographRecords();
    }
    /**
     * 发放折扣券
     * @return  bool
    */
    public static function manualSendPhotographCoupons (array $staffIds, bool $regular = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualSendPhotographCoupons(["staffIds" => $staffIds, "regular" => $regular]);
    }
    /**
     * 领券配置信息
     * @return  array
    */
    public static function getOptions () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOptions();
    }
    /**
     * 领券文案配置信息
     * @return  array
    */
    public static function getTextOptions () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTextOptions();
    }
    /**
     * 815给正式员工发放8.5折扣券
     * @return  bool
    */
    public static function extraCoupon () {
        return RpcClass::getClass(self::$serviceName, self::$className)->extraCoupon();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}