<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-26 11:38:13
 */
namespace Mainto\Bridge\Invokes\ProjectThinking;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PlanetBroadcastManage
 */
class PlanetBroadcastManage {
    private static string $serviceName = "ProjectThinking";

    private static string $className = "PlanetBroadcastManage";

    /**
     * 创建记录【state默认上线】
     * @return  mixed
    */
    public static function createBroadcast (string $type, string $image, string $title, int $read_time, int $wish_value, string $content, array $to_group, array $appendix, array $extend, bool $is_broadcast = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createBroadcast(["type" => $type, "image" => $image, "title" => $title, "read_time" => $read_time, "wish_value" => $wish_value, "content" => $content, "to_group" => $to_group, "appendix" => $appendix, "extend" => $extend, "is_broadcast" => $is_broadcast]);
    }
    /**
     * 更新广播
     * @return  mixed
    */
    public static function editBroadcast (string $_id, string $type, string $image, string $title, int $read_time, int $wish_value, string $content, array $to_group, array $appendix, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editBroadcast(["_id" => $_id, "type" => $type, "image" => $image, "title" => $title, "read_time" => $read_time, "wish_value" => $wish_value, "content" => $content, "to_group" => $to_group, "appendix" => $appendix, "extend" => $extend]);
    }
    /**
     * 获取广播详情
     * @return  mixed
    */
    public static function getBroadcastDetail (string $_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBroadcastDetail(["_id" => $_id]);
    }
    /**
     * 广播列表查询
     * @return  mixed
    */
    public static function getBroadcastList (string $title, int $to_group, string $type, string $created_at_start, string $created_at_end, int $page = 1, int $page_size = 10, bool $all) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBroadcastList(["title" => $title, "to_group" => $to_group, "type" => $type, "created_at_start" => $created_at_start, "created_at_end" => $created_at_end, "page" => $page, "page_size" => $page_size, "all" => $all]);
    }
    /**
     * 上线
     * @return  mixed
    */
    public static function online (string $_id, string $state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->online(["_id" => $_id, "state" => $state]);
    }
    /**
     * 下线
     * @return  mixed
    */
    public static function offline (string $_id, string $state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->offline(["_id" => $_id, "state" => $state]);
    }
    /**
     * 导出未阅读数
     * @return  mixed
    */
    public static function exportUnread (string $broadcast_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportUnread(["broadcast_id" => $broadcast_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}