<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-01 10:24:15
 */
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SpaceStation
 */
class SpaceStation {
    private static string $serviceName = "ProjectThinking";

    private static string $className = "User\\SpaceStation\\SpaceStation";

    /**
     * 获取所有的banner
     * @return  array
    */
    public static function getAllBanners (string $title, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllBanners(["title" => $title, "status" => $status]);
    }
    /**
     * 首页
     * @return  mixed
    */
    public static function getSpaceStationIndex (int $page = 1, int $pageSize = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpaceStationIndex(["page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 活动广场列表
     * @return  mixed
    */
    public static function getActivityList (string $status, string $type, int $page = 1, int $pageSize = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityList(["status" => $status, "type" => $type, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 活动详情获得
     * @return  mixed
    */
    public static function getActivity (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivity(["id" => $id]);
    }
    /**
     * 活动报名
     * @return  mixed
    */
    public static function signupActivity (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->signupActivity(["id" => $id]);
    }
    /**
     * 活动签到
     * @return  mixed
    */
    public static function signinActivity (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->signinActivity(["id" => $id]);
    }
    /**
     * 员工档案.操课券和学分
     * @return  mixed
    */
    public static function getStaffArchive (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffArchive(["staffId" => $staffId]);
    }
    /**
     * 活动广场.我的活动
     * @return  mixed
    */
    public static function getMyActivityList (int $page = 1, int $pageSize = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMyActivityList(["page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 生活助手和福利礼包列表
     * @return  mixed
    */
    public static function getInformationList (int $page = 1, int $pageSize = 5, string $type, string $childType, string $title, bool $isAll = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInformationList(["page" => $page, "pageSize" => $pageSize, "type" => $type, "childType" => $childType, "title" => $title, "isAll" => $isAll]);
    }
    /**
     * 资讯详情获得
     * @return  mixed
    */
    public static function getInformation (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInformation(["id" => $id]);
    }
    /**
     * 资讯阅读量
     * @return  mixed
    */
    public static function addRecord (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRecord(["id" => $id]);
    }
    /**
     * 资讯阅读添加愿望值
     * @return  mixed
    */
    public static function award (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->award(["id" => $id]);
    }
    /**
     * 愿望城堡的愿望值变更提示标记
     * @return  mixed
    */
    public static function hasWishNotice () {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasWishNotice();
    }
    /**
     * 根据是否提醒过获取愿望值变更记录
     * @return  mixed
    */
    public static function getWishRecord (bool $hasNotice) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWishRecord(["hasNotice" => $hasNotice]);
    }
    /**
     * 服务器时间
     * @return  mixed
    */
    public static function getServerTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServerTime();
    }
    /**
     * websocket连接
     * @return  mixed
    */
    public static function webSocket () {
        return RpcClass::getClass(self::$serviceName, self::$className)->webSocket();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}