<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-22 15:00:28
 */
namespace Mainto\Bridge\Invokes\ProjectThinking\User\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CouponCoffee
 */
class CouponCoffee {
    private static string $serviceName = "ProjectThinking";

    private static string $className = "User\\SpaceStation\\CouponCoffee";

    /**
     * 咖啡券列表
     * @return  mixed
    */
    public static function getCoffeeCouponList (bool $isUsed = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCoffeeCouponList(["isUsed" => $isUsed]);
    }
    /**
     * 发放咖啡券定时任务
     * @return  mixed
    */
    public static function cronCoffeeCoupons () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronCoffeeCoupons();
    }
    /**
     * 新人入职发放咖啡券
     * @return  mixed
    */
    public static function newStaffCoffeeCoupons (int $staff_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newStaffCoffeeCoupons(["staff_id" => $staff_id]);
    }
    /**
     * 重新入职发放咖啡券
     * @return  mixed
    */
    public static function recoverStaffCoffeeCoupons (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recoverStaffCoffeeCoupons(["staffId" => $staffId]);
    }
    /**
     * 咖啡券信息.核销
     * @return  mixed
    */
    public static function getCouponInfo (string $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouponInfo(["id" => $id]);
    }
    /**
     * 咖啡券核销
     * @return  mixed
    */
    public static function checkCoffeeCoupon (string $id, string $prodName, float $prodPrice) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkCoffeeCoupon(["id" => $id, "prodName" => $prodName, "prodPrice" => $prodPrice]);
    }
    /**
     * 咖啡券列表.导出
     * @return  array
    */
    public static function exportCoffeeCouponList (int $page = 1, int $pageSize = 10, string $beginAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportCoffeeCouponList(["page" => $page, "pageSize" => $pageSize, "beginAt" => $beginAt, "endAt" => $endAt]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}