<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Talent;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method importByParams(array $params)
 * @method areaTreeByParams(array $params)
 * @method getImportTemplateByParams(array $params)
 * @method exportByParams(array $params)
 * @method getAreaManagerAmountByParams(array $params)
 */
class TalentArea {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 区域人才情况
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectThinking\Talent\DTO\AreaListDTO
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 导入数据
     *
     * @param  array $data 导入数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function import (array $data) {
        return self::getClass()->import([
            "data" => $data,
        ]);
    }

    /**
     * 区域树
     *
     * @throws  \Exception
     * @return  array
     */
    public static function areaTree () {
        return self::getClass()->areaTree();
    }

    /**
     * 获取导入数据模版
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getImportTemplate () {
        return self::getClass()->getImportTemplate();
    }

    /**
     * 导出
     *
     * @throws  \Exception
     * @return  array
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * 获取各区域店长人数
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function getAreaManagerAmount () {
        return self::getClass()->getAreaManagerAmount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Talent\TalentArea');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Talent\TalentArea');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}