<?php
namespace Mainto\Bridge\Invokes\ProjectThinking\Manage\SpaceStation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method exportByParams(array $params)
 */
class Anniversary {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 周年列表
     *
     * @support  int $staffId 工号 [ require false ]
     * @support  string $name 姓名 [ require false ]
     * @support  string $month 时间 [ require false ]
     * @support  array $serial 周年数 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 15) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 周年列表导出
     *
     * @support  int $staffId 工号 [ require false ]
     * @support  string $name 姓名 [ require false ]
     * @support  string $month 时间 [ require false ]
     * @support  array $serial 周年数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function export () {
        return self::getClass()->export([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectThinking', 'Manage\SpaceStation\Anniversary');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectThinking', 'Manage\SpaceStation\Anniversary');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}